@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Tour Sales Manage</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Tour Sales</a>
                                    </li>
                                    <li class="breadcrumb-item active">Add Tour Sales</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->


                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif



                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="mt-0 header-title"> Tour Sales</h4>

                                <div class="row">
                                    <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                                        <div id="tg-content" class="tg-content">

                                            <div class="mapset row">
                                                <div class="col-xs-12 col-sm-6 col-md-8 col-lg-8">
                                                   
                                                    <form class="form-horizontal">
                                                        <!-- Origin input with autocomplete -->
                                                        <div class="form-group">
                                                            <label for="origin" class="col-xs-2 control-label">
                                                                <i class="far fa-dot-circle"></i>
                                                            </label>
                                                            <div class="col-xs-10">
                                                                <input type="text" id="origin" placeholder="Origin"
                                                                    class="form-control" />
                                                            </div>
                                                        </div>
                                                        <!-- Destination inputs (dynamically added) -->
                                                    </form>
                                                    <div style="margin-bottom: 10px;" class="col-xs-offset-2 col-xs-10 ">
                                                        <button class="btn btn-primary" onclick="addDestinationInput();">
                                                            Add Destination
                                                        </button>

                                                        <button class="btn btn-success " onclick="calculateDistance();">
                                                            <i class="fa fa-arrow-circle-o-right" aria-hidden="true"></i>
                                                            Calculate Distance
                                                        </button>

                                                    </div>
                                                </div>
                                                <div class="col-xs-12 col-sm-6 col-md-4 col-lg-4">
                                                    <div id="output"></div>
                                                    <div class="discard">
                                                        <div>
                                                            <div id="distances">

                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>



                                        </div>
                                    </div>
                                </div>
                                <div class="container-fluid">
                                    <div id="googleMap" style="width: 100%; height: 400px"></div>

                                </div>
                                <div class="fm">
                                    <form action="/finished-tour" enctype="multipart/form-data" method="post">
                                        @csrf
                                        <div class="form-group ">
                                            <label for="example-text-input" class="col-sm-2 col-form-label">Name</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" readonly
                                                    value="{{ $data->name }}" name="name" required>
                                                <input class="form-control" type="hidden" value="{{ $data->id }}"
                                                    name="clientid" required>
                                            </div>
                                        </div>

                                        <div class="form-group ">
                                            <label for="example-text-input" class="col-sm-2 col-form-label">Price</label>
                                            <div class="col-sm-10">
                                                <input class="form-control" type="text" placeholder=" " name="price">
                                            </div>
                                        </div>


                                        <input class="form-control" id="places" type="hidden" placeholder=" "
                                            name="places">




                                        <div class="form-group ">
                                            <label for="example-text-input" class="col-sm-2 col-form-label">Note</label>
                                            <div class="col-sm-10">
                                                <textarea required name="note" class="form-control" id="" cols="30" rows="10"></textarea>

                                            </div>
                                        </div>





                                        <div class="form-group mb-0">
                                            <div>
                                                <button type="submit" class="btn btn-primary waves-effect waves-light">
                                                    Submit
                                                </button>
                                                <button type="reset" class="btn btn-secondary waves-effect m-l-5">
                                                    Cancel
                                                </button>
                                            </div>
                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end col -->
                </div>

            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->


        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script>
            jQuery(document).ready(function() {
                $('.summernote').summernote({
                    height: 300, // set editor height
                    minHeight: null, // set minimum height of editor
                    maxHeight: null, // set maximum height of editor
                    focus: true // set focus to editable area after initializing summernote
                });
            });
        </script>
        <script src="https://maps.googleapis.com/maps/api/js?libraries=places&key=AIzaSyDql98PYRkfw52KazQjeaGgB6C3ZEaHR_4">
        </script>
    @endsection
